//+------------------------------------------------------------------+
//|                                          supreme 1st version.mq4 |
//|             Huisman84Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Huisman84Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

extern double Prots = 20;
extern double StopLoss = 800;

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
  double MAFcurrent, MAFprevious;
  double MAScurrent, MASprevious;
  double Lots;
  int cnt, ticket, total;
  
//----
  if (Bars<100)
    {
   Print("bars less than 100");
   return(0);
    }
  
//----
   MAFcurrent=iMA(NULL,0,5,0,MODE_EMA,PRICE_CLOSE,0);
   MAFprevious=iMA(NULL,0,5,0,MODE_EMA,PRICE_CLOSE,1);
   MAScurrent=iMA(NULL,0,25,0,MODE_SMA,PRICE_CLOSE,0);
   MASprevious=iMA(NULL,0,25,0,MODE_SMA,PRICE_CLOSE,1);
   Lots = 0.5;

   
   total=OrdersTotal();
   if(total<1) 
     {
      // no opened orders identified
      if(AccountFreeMargin()<(1000*Lots))
        {
         Print("We have no money. Free Margin = ", AccountFreeMargin());
         return(0);  
        }
      // check for long position (BUY) possibility  
      if(MAFcurrent>MAScurrent && MAFprevious<MASprevious)
        {
         ticket=OrderSend(Symbol(),OP_BUY,Lots,Ask,3,Ask-StopLoss*Point,0,"supreme",16384,0,Green);
         if(ticket>0)
           {
            if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES)) Print("BUY order opened : ",OrderOpenPrice());
           }
         else Print("orderSend failed with error #", GetLastError());
         return(0);
        }
      // check for short position (SELL) possibility
      if(MAFcurrent<MAScurrent && MAFprevious>MASprevious)
        {
         ticket=OrderSend(Symbol(),OP_SELL,Lots,Bid,3,Bid+StopLoss*Point,0,"supreme",16384,0,Red);
         if(ticket>0)
           {
            if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES)) Print("SELL order opened : ",OrderOpenPrice());
           }
         else Print("orderSend failed with error #", GetLastError());
         return(0);
        }
      return(0);
     }  // exit market correctly...
       for(cnt=0;cnt<total;cnt++)
         {
          OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
          if(OrderType()<=OP_SELL &&   // check for opened position 
             OrderSymbol()==Symbol())  // check for symbol
            {
             if(OrderType()==OP_BUY)   // long position is opened
               {
                // should it be closed?  
                if(MAFcurrent<MAScurrent && MAFprevious>MASprevious)
                    {
                     OrderClose(OrderTicket(),OrderLots(),Bid,3,Violet); // close position
                     return(0); // exit
                    }
               }
              else // go to short position
               {
                  // should it be closed?
                if(MAFcurrent>MAScurrent && MAFprevious<MASprevious)
                  {
                   OrderClose(OrderTicket(),OrderLots(),Ask,3,Violet); // close position
                   return(0); // exit
                  }
               }
            }         
         }         
       return(0);
  }




